<?php

namespace Tests\Browser\Modules\GST;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\GST\Entities\GstTax;
use Tests\DuskTestCase;

class GSTTest extends DuskTestCase
{
    use WithFaker;
    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $lists = GstTax::where('id', '>', 3)->pluck('id');
        GstTax::destroy($lists);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/gst-setup/gst')
                ->assertSee('GST List');
        });
    }

    public function test_for_validate_create_gst(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#gstForm > div > div > div.col-lg-12.text-center > button')
                ->waitForTextIn('#name_error', 'The name field is required.', 25)
                ->waitForTextIn('#rate_error', 'The rate field is required.', 25);

        });
    }

    public function test_for_create_gst(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#name', 'test-gst')
                ->type('#rate', '15')
                ->click('#gstForm > div > div > div:nth-child(3) > div > ul > li:nth-child(2) > label > span')
                ->click('#gstForm > div > div > div.col-lg-12.text-center > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
    }

    public function test_for_edit_gst(){
        $this->test_for_create_gst();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#DataTables_Table_1_filter > label > input[type=search]', 25)
                ->type('#DataTables_Table_1_filter > label > input[type=search]', 'test-gst')
                ->pause(2000)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > div > a.dropdown-item.edit_gst')
                ->waitForTextIn('#main-content > section > div > div > div.col-lg-4 > div.edit_div > div > div > h3', 'Edit GST', 2)
                ->type('#gstEditForm > div > div > div.col-xl-12 > div > input', 'test-gst-edit')
                ->type('#gstEditForm > div > div > div:nth-child(3) > div > input', '9')
                ->click('#gstEditForm > div > div > div:nth-child(4) > div > ul > li:nth-child(1) > label > span')
                ->click('#gstEditForm > div > div > div.col-lg-12.text-center > button')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_validate_edit_gst(){
        $this->test_for_create_gst();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#DataTables_Table_1_filter > label > input[type=search]', 25)
                ->type('#DataTables_Table_1_filter > label > input[type=search]', 'test-gst')
                ->pause(2000)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > div > a.dropdown-item.edit_gst')
                ->waitForTextIn('#main-content > section > div > div > div.col-lg-4 > div.edit_div > div > div > h3', 'Edit GST', 2)
                ->type('#gstEditForm > div > div > div.col-xl-12 > div > input', '')
                ->type('#gstEditForm > div > div > div:nth-child(3) > div > input', '')
                ->click('#gstEditForm > div > div > div:nth-child(4) > div > ul > li:nth-child(1) > label > span')
                ->click('#gstEditForm > div > div > div.col-lg-12.text-center > button')
                ->waitForTextIn('#edit_name_error', 'The name field is required.', 25)
                ->waitForTextIn('#edit_rate_error', 'The rate field is required.', 25);
        });
    }

    public function test_for_delete_gst(){
        $this->test_for_create_gst();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#DataTables_Table_1_filter > label > input[type=search]', 25)
                ->type('#DataTables_Table_1_filter > label > input[type=search]', 'test-gst')
                ->pause(2000)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > div > a:nth-child(2)')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/gst-setup/gst');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');

        });        
    }

}
