<?php

namespace Tests\Browser\Modules\Product;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Product\Entities\UnitType;
use Tests\DuskTestCase;

class ProductUnitTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $units = UnitType::pluck('id');
        UnitType::destroy($units);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/product/units')
                    ->assertSee('Units');
        });
    }

    public function test_for_create_unit(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#name', $this->faker->name)
                ->click('#unitForm > div > div > div:nth-child(2) > div > ul > li:nth-child(2) > label > span')
                ->click('#unitForm > div > div > div.col-lg-12.text-center > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
    }

    public function test_for_edit_unit(){
        $this->test_for_create_unit();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > button', 30)
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > div > a.dropdown-item.edit_unit')
                ->waitForText('Edit Unit', 4)
                ->type('#unitEditForm > div > div > div.col-xl-12 > div > input', $this->faker->name)
                ->click('#unitEditForm > div > div > div:nth-child(3) > div > ul > li:nth-child(1) > label > span')
                ->click('#unitEditForm > div > div > div.col-lg-12.text-center > button')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_deleted_unit(){
        $this->test_for_create_unit();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > button', 30)
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > div > a.dropdown-item.delete_unit')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/product/units');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });
    }
    
}
