<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2\Service\Entity;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class FactorOptions {
    /**
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @param string $friendlyName The friendly name of this Factor
     * @param string $configNotificationToken For APN, the device token. For FCM,
     *                                        the registration token
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @param int $configTimeStep How often, in seconds, are TOTP codes generated
     * @param int $configSkew The number of past and future time-steps valid at a
     *                        given time
     * @param int $configCodeLength Number of digits for generated TOTP codes
     * @param string $configAlg The algorithm used to derive the TOTP codes
     * @return UpdateFactorOptions Options builder
     */
    public static function update(string $authPayload = Values::NONE, string $friendlyName = Values::NONE, string $configNotificationToken = Values::NONE, string $configSdkVersion = Values::NONE, int $configTimeStep = Values::NONE, int $configSkew = Values::NONE, int $configCodeLength = Values::NONE, string $configAlg = Values::NONE): UpdateFactorOptions {
        return new UpdateFactorOptions($authPayload, $friendlyName, $configNotificationToken, $configSdkVersion, $configTimeStep, $configSkew, $configCodeLength, $configAlg);
    }
}

class UpdateFactorOptions extends Options {
    /**
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @param string $friendlyName The friendly name of this Factor
     * @param string $configNotificationToken For APN, the device token. For FCM,
     *                                        the registration token
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @param int $configTimeStep How often, in seconds, are TOTP codes generated
     * @param int $configSkew The number of past and future time-steps valid at a
     *                        given time
     * @param int $configCodeLength Number of digits for generated TOTP codes
     * @param string $configAlg The algorithm used to derive the TOTP codes
     */
    public function __construct(string $authPayload = Values::NONE, string $friendlyName = Values::NONE, string $configNotificationToken = Values::NONE, string $configSdkVersion = Values::NONE, int $configTimeStep = Values::NONE, int $configSkew = Values::NONE, int $configCodeLength = Values::NONE, string $configAlg = Values::NONE) {
        $this->options['authPayload'] = $authPayload;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['configNotificationToken'] = $configNotificationToken;
        $this->options['configSdkVersion'] = $configSdkVersion;
        $this->options['configTimeStep'] = $configTimeStep;
        $this->options['configSkew'] = $configSkew;
        $this->options['configCodeLength'] = $configCodeLength;
        $this->options['configAlg'] = $configAlg;
    }

    /**
     * The optional payload needed to verify the Factor for the first time. E.g. for a TOTP, the numeric code.
     *
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @return $this Fluent Builder
     */
    public function setAuthPayload(string $authPayload): self {
        $this->options['authPayload'] = $authPayload;
        return $this;
    }

    /**
     * The new friendly name of this Factor. It can be up to 64 characters.
     *
     * @param string $friendlyName The friendly name of this Factor
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * For APN, the device token. For FCM, the registration token. It is used to send the push notifications. Required when `factor_type` is `push`. If specified, this value must be between 32 and 255 characters long.
     *
     * @param string $configNotificationToken For APN, the device token. For FCM,
     *                                        the registration token
     * @return $this Fluent Builder
     */
    public function setConfigNotificationToken(string $configNotificationToken): self {
        $this->options['configNotificationToken'] = $configNotificationToken;
        return $this;
    }

    /**
     * The Verify Push SDK version used to configure the factor
     *
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @return $this Fluent Builder
     */
    public function setConfigSdkVersion(string $configSdkVersion): self {
        $this->options['configSdkVersion'] = $configSdkVersion;
        return $this;
    }

    /**
     * Defines how often, in seconds, are TOTP codes generated. i.e, a new TOTP code is generated every time_step seconds. Must be between 20 and 60 seconds, inclusive
     *
     * @param int $configTimeStep How often, in seconds, are TOTP codes generated
     * @return $this Fluent Builder
     */
    public function setConfigTimeStep(int $configTimeStep): self {
        $this->options['configTimeStep'] = $configTimeStep;
        return $this;
    }

    /**
     * The number of time-steps, past and future, that are valid for validation of TOTP codes. Must be between 0 and 2, inclusive
     *
     * @param int $configSkew The number of past and future time-steps valid at a
     *                        given time
     * @return $this Fluent Builder
     */
    public function setConfigSkew(int $configSkew): self {
        $this->options['configSkew'] = $configSkew;
        return $this;
    }

    /**
     * Number of digits for generated TOTP codes. Must be between 3 and 8, inclusive
     *
     * @param int $configCodeLength Number of digits for generated TOTP codes
     * @return $this Fluent Builder
     */
    public function setConfigCodeLength(int $configCodeLength): self {
        $this->options['configCodeLength'] = $configCodeLength;
        return $this;
    }

    /**
     * The algorithm used to derive the TOTP codes. Can be `sha1`, `sha256` or `sha512`
     *
     * @param string $configAlg The algorithm used to derive the TOTP codes
     * @return $this Fluent Builder
     */
    public function setConfigAlg(string $configAlg): self {
        $this->options['configAlg'] = $configAlg;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.UpdateFactorOptions ' . $options . ']';
    }
}